/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.tabbedpane;

import com.github.weisj.darklaf.ui.tabbedpane.DarkTabbedPaneUIBridge;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;

public abstract class TabbedPaneLayout
implements LayoutManager {
    protected final DarkTabbedPaneUIBridge ui;

    public TabbedPaneLayout(DarkTabbedPaneUIBridge ui) {
        this.ui = ui;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this.calculateSize(false);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.calculateSize(true);
    }

    @Override
    public void layoutContainer(Container parent) {
        this.ui.setRolloverTab(-1);
        int tabPlacement = this.ui.tabPane.getTabPlacement();
        Insets insets = this.ui.tabPane.getInsets();
        int selectedIndex = this.ui.tabPane.getSelectedIndex();
        Component visibleComponent = this.ui.getVisibleComponent();
        this.calculateLayoutInfo();
        Component selectedComponent = null;
        if (selectedIndex < 0) {
            if (visibleComponent != null) {
                this.ui.setVisibleComponent(null);
            }
        } else {
            selectedComponent = this.ui.tabPane.getComponentAt(selectedIndex);
        }
        int totalTabWidth = 0;
        int totalTabHeight = 0;
        Insets contentInsets = this.ui.getContentBorderInsets(tabPlacement);
        boolean shouldChangeFocus = false;
        if (selectedComponent != null) {
            if (selectedComponent != visibleComponent && visibleComponent != null && SwingUtilities.findFocusOwner(visibleComponent) != null) {
                shouldChangeFocus = true;
            }
            this.ui.setVisibleComponent(selectedComponent);
        }
        Rectangle bounds = this.ui.tabPane.getBounds();
        int numChildren = this.ui.tabPane.getComponentCount();
        if (numChildren > 0) {
            int cy;
            int cx;
            switch (tabPlacement) {
                case 2: {
                    totalTabWidth = this.ui.calculateTabAreaWidth(tabPlacement, this.ui.runCount, this.ui.maxTabWidth);
                    cx = insets.left + totalTabWidth + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    break;
                }
                case 4: {
                    totalTabWidth = this.ui.calculateTabAreaWidth(tabPlacement, this.ui.runCount, this.ui.maxTabWidth);
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    break;
                }
                case 3: {
                    totalTabHeight = this.ui.calculateTabAreaHeight(tabPlacement, this.ui.runCount, this.ui.maxTabHeight);
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + contentInsets.top;
                    break;
                }
                default: {
                    totalTabHeight = this.ui.calculateTabAreaHeight(tabPlacement, this.ui.runCount, this.ui.maxTabHeight);
                    cx = insets.left + contentInsets.left;
                    cy = insets.top + totalTabHeight + contentInsets.top;
                }
            }
            int cw = bounds.width - totalTabWidth - insets.left - insets.right - contentInsets.left - contentInsets.right;
            int ch = bounds.height - totalTabHeight - insets.top - insets.bottom - contentInsets.top - contentInsets.bottom;
            for (int i = 0; i < numChildren; ++i) {
                Component child = this.ui.tabPane.getComponent(i);
                if (child == this.ui.tabContainer) {
                    int tabContainerWidth = totalTabWidth == 0 ? bounds.width : totalTabWidth + insets.left + insets.right + contentInsets.left + contentInsets.right;
                    int tabContainerHeight = totalTabHeight == 0 ? bounds.height : totalTabHeight + insets.top + insets.bottom + contentInsets.top + contentInsets.bottom;
                    int tabContainerX = 0;
                    int tabContainerY = 0;
                    if (tabPlacement == 3) {
                        tabContainerY = bounds.height - tabContainerHeight;
                    } else if (tabPlacement == 4) {
                        tabContainerX = bounds.width - tabContainerWidth;
                    }
                    child.setBounds(tabContainerX, tabContainerY, tabContainerWidth, tabContainerHeight);
                    continue;
                }
                child.setBounds(cx, cy, cw, ch);
            }
        }
        this.layoutTabComponents();
        if (shouldChangeFocus && !this.ui.requestFocusForVisibleComponent()) {
            this.ui.tabPane.requestFocusInWindow();
        }
    }

    public void calculateLayoutInfo() {
        int tabCount = this.ui.tabPane.getTabCount();
        this.ui.assureRectsCreated(tabCount);
        this.calculateTabRects(this.ui.tabPane.getTabPlacement(), tabCount);
        this.ui.isRunsDirty = false;
    }

    protected abstract void layoutTabComponents();

    protected void calculateTabRects(int tabPlacement, int tabCount) {
        Rectangle rect;
        int i;
        int returnAt;
        int y;
        int x;
        FontMetrics metrics = this.ui.getFontMetrics();
        Dimension size = this.ui.tabPane.getSize();
        Insets insets = this.ui.tabPane.getInsets();
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        int fontHeight = metrics.getHeight();
        int selectedIndex = this.ui.tabPane.getSelectedIndex();
        boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
        boolean leftToRight = this.ui.tabPane.getComponentOrientation().isLeftToRight();
        switch (tabPlacement) {
            case 2: {
                this.ui.maxTabWidth = this.ui.calculateMaxTabWidth(tabPlacement);
                x = insets.left + tabAreaInsets.left;
                y = insets.top + tabAreaInsets.top;
                returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                break;
            }
            case 4: {
                this.ui.maxTabWidth = this.ui.calculateMaxTabWidth(tabPlacement);
                x = size.width - insets.right - tabAreaInsets.right - this.ui.maxTabWidth;
                y = insets.top + tabAreaInsets.top;
                returnAt = size.height - (insets.bottom + tabAreaInsets.bottom);
                break;
            }
            case 3: {
                this.ui.maxTabHeight = this.ui.calculateMaxTabHeight(tabPlacement);
                x = insets.left + tabAreaInsets.left;
                y = size.height - insets.bottom - tabAreaInsets.bottom - this.ui.maxTabHeight;
                returnAt = size.width - (insets.right + tabAreaInsets.right);
                break;
            }
            default: {
                this.ui.maxTabHeight = this.ui.calculateMaxTabHeight(tabPlacement);
                x = insets.left + tabAreaInsets.left;
                y = insets.top + tabAreaInsets.top;
                returnAt = size.width - (insets.right + tabAreaInsets.right);
            }
        }
        int tabRunOverlay = this.ui.getTabRunOverlay(tabPlacement);
        this.ui.runCount = 0;
        this.ui.selectedRun = -1;
        if (tabCount == 0) {
            return;
        }
        for (i = 0; i < tabCount; ++i) {
            rect = this.ui.rects[i];
            if (!verticalTabRuns) {
                if (i > 0) {
                    rect.x = this.ui.rects[i - 1].x + this.ui.rects[i - 1].width;
                } else {
                    this.ui.tabRuns[0] = 0;
                    this.ui.runCount = 1;
                    this.ui.maxTabWidth = 0;
                    rect.x = x;
                }
                rect.width = this.ui.calculateTabWidth(tabPlacement, i, metrics);
                this.ui.maxTabWidth = Math.max(this.ui.maxTabWidth, rect.width);
                if (rect.x != x && rect.x + rect.width > returnAt) {
                    if (this.ui.runCount > this.ui.tabRuns.length - 1) {
                        this.ui.expandTabRunsArray();
                    }
                    this.ui.tabRuns[this.ui.runCount] = i;
                    ++this.ui.runCount;
                    rect.x = x;
                }
                rect.y = y;
                rect.height = this.ui.maxTabHeight;
            } else {
                if (i > 0) {
                    rect.y = this.ui.rects[i - 1].y + this.ui.rects[i - 1].height;
                } else {
                    this.ui.tabRuns[0] = 0;
                    this.ui.runCount = 1;
                    this.ui.maxTabHeight = 0;
                    rect.y = y;
                }
                rect.height = this.ui.calculateTabHeight(tabPlacement, i, fontHeight);
                this.ui.maxTabHeight = Math.max(this.ui.maxTabHeight, rect.height);
                if (rect.y != y && rect.y + rect.height > returnAt) {
                    if (this.ui.runCount > this.ui.tabRuns.length - 1) {
                        this.ui.expandTabRunsArray();
                    }
                    this.ui.tabRuns[this.ui.runCount] = i;
                    ++this.ui.runCount;
                    rect.y = y;
                }
                rect.x = x;
                rect.width = this.ui.maxTabWidth;
            }
            if (i != selectedIndex) continue;
            this.ui.selectedRun = this.ui.runCount - 1;
        }
        if (this.ui.runCount > 1) {
            this.normalizeTabRuns(tabPlacement, tabCount, verticalTabRuns ? y : x, returnAt);
            this.ui.selectedRun = this.ui.getRunForTab(tabCount, selectedIndex);
            if (this.ui.shouldRotateTabRuns(tabPlacement)) {
                this.rotateTabRuns(tabPlacement, this.ui.selectedRun);
            }
        }
        for (i = this.ui.runCount - 1; i >= 0; --i) {
            int j;
            int end;
            int start = this.ui.tabRuns[i];
            int next = this.ui.tabRuns[i == this.ui.runCount - 1 ? 0 : i + 1];
            int n = end = next != 0 ? next - 1 : tabCount - 1;
            if (!verticalTabRuns) {
                for (j = start; j <= end; ++j) {
                    rect = this.ui.rects[j];
                    rect.y = y;
                    rect.x += this.ui.getTabRunIndent(tabPlacement, i);
                }
                if (this.ui.shouldPadTabRun(tabPlacement, i)) {
                    this.padTabRun(tabPlacement, start, end, returnAt);
                }
                if (tabPlacement == 3) {
                    y -= this.ui.maxTabHeight - tabRunOverlay;
                    continue;
                }
                y += this.ui.maxTabHeight - tabRunOverlay;
                continue;
            }
            for (j = start; j <= end; ++j) {
                rect = this.ui.rects[j];
                rect.x = x;
                rect.y += this.ui.getTabRunIndent(tabPlacement, i);
            }
            if (this.ui.shouldPadTabRun(tabPlacement, i)) {
                this.padTabRun(tabPlacement, start, end, returnAt);
            }
            if (tabPlacement == 4) {
                x -= this.ui.maxTabWidth - tabRunOverlay;
                continue;
            }
            x += this.ui.maxTabWidth - tabRunOverlay;
        }
        this.centerTabs(tabPlacement, tabCount, returnAt);
        this.padSelectedTab(tabPlacement, selectedIndex);
        if (!leftToRight && !verticalTabRuns) {
            int rightMargin = size.width - (insets.right + tabAreaInsets.right);
            int leftMargin = insets.left + tabAreaInsets.left;
            for (i = 0; i < tabCount; ++i) {
                this.ui.rects[i].x = rightMargin - this.ui.rects[i].x - this.ui.rects[i].width + leftMargin;
            }
        }
    }

    protected abstract void centerTabs(int var1, int var2, int var3);

    protected void normalizeTabRuns(int tabPlacement, int tabCount, int start, int max) {
        boolean verticalTabRuns = tabPlacement == 2 || tabPlacement == 4;
        int run = this.ui.runCount - 1;
        boolean keepAdjusting = true;
        double weight = 1.25;
        while (keepAdjusting) {
            int prevLastLen;
            int end;
            int last = this.ui.lastTabInRun(tabCount, run);
            int prevLast = this.ui.lastTabInRun(tabCount, run - 1);
            if (!verticalTabRuns) {
                end = this.ui.rects[last].x + this.ui.rects[last].width;
                prevLastLen = (int)((double)this.ui.maxTabWidth * weight);
            } else {
                end = this.ui.rects[last].y + this.ui.rects[last].height;
                prevLastLen = (int)((double)this.ui.maxTabHeight * weight * 2.0);
            }
            if (max - end > prevLastLen) {
                this.ui.tabRuns[run] = prevLast;
                if (!verticalTabRuns) {
                    this.ui.rects[prevLast].x = start;
                } else {
                    this.ui.rects[prevLast].y = start;
                }
                for (int i = prevLast + 1; i <= last; ++i) {
                    if (!verticalTabRuns) {
                        this.ui.rects[i].x = this.ui.rects[i - 1].x + this.ui.rects[i - 1].width;
                        continue;
                    }
                    this.ui.rects[i].y = this.ui.rects[i - 1].y + this.ui.rects[i - 1].height;
                }
            } else if (run == this.ui.runCount - 1) {
                keepAdjusting = false;
            }
            if (run - 1 > 0) {
                --run;
                continue;
            }
            run = this.ui.runCount - 1;
            weight += 0.25;
        }
    }

    protected void rotateTabRuns(int tabPlacement, int selectedRun) {
        for (int i = 0; i < selectedRun; ++i) {
            int save = this.ui.tabRuns[0];
            if (this.ui.runCount - 1 >= 0) {
                System.arraycopy(this.ui.tabRuns, 1, this.ui.tabRuns, 0, this.ui.runCount - 1);
            }
            this.ui.tabRuns[this.ui.runCount - 1] = save;
        }
    }

    protected void padTabRun(int tabPlacement, int start, int end, int max) {
        Rectangle lastRect = this.ui.rects[end];
        if (tabPlacement == 1 || tabPlacement == 3) {
            int runWidth = lastRect.x + lastRect.width - this.ui.rects[start].x;
            int deltaWidth = max - (lastRect.x + lastRect.width);
            float factor = (float)deltaWidth / (float)runWidth;
            for (int j = start; j <= end; ++j) {
                Rectangle pastRect = this.ui.rects[j];
                if (j > start) {
                    pastRect.x = this.ui.rects[j - 1].x + this.ui.rects[j - 1].width;
                }
                pastRect.width += Math.round((float)pastRect.width * factor);
            }
            lastRect.width = max - lastRect.x;
        } else {
            int runHeight = lastRect.y + lastRect.height - this.ui.rects[start].y;
            int deltaHeight = max - (lastRect.y + lastRect.height);
            float factor = (float)deltaHeight / (float)runHeight;
            for (int j = start; j <= end; ++j) {
                Rectangle pastRect = this.ui.rects[j];
                if (j > start) {
                    pastRect.y = this.ui.rects[j - 1].y + this.ui.rects[j - 1].height;
                }
                pastRect.height += Math.round((float)pastRect.height * factor);
            }
            lastRect.height = max - lastRect.y;
        }
    }

    protected void padSelectedTab(int tabPlacement, int selectedIndex) {
        if (selectedIndex >= 0) {
            Rectangle selRect = this.ui.rects[selectedIndex];
            Insets padInsets = this.ui.getSelectedTabPadInsets(tabPlacement);
            selRect.x -= padInsets.left;
            selRect.width += padInsets.left + padInsets.right;
            selRect.y -= padInsets.top;
            selRect.height += padInsets.top + padInsets.bottom;
            if (!this.ui.scrollableTabLayoutEnabled()) {
                Dimension size = this.ui.tabPane.getSize();
                Insets insets = this.ui.tabPane.getInsets();
                if (tabPlacement == 2 || tabPlacement == 4) {
                    int bottom;
                    int top = insets.top - selRect.y;
                    if (top > 0) {
                        selRect.y += top;
                        selRect.height -= top;
                    }
                    if ((bottom = selRect.y + selRect.height + insets.bottom - size.height) > 0) {
                        selRect.height -= bottom;
                    }
                } else {
                    int right;
                    int left = insets.left - selRect.x;
                    if (left > 0) {
                        selRect.x += left;
                        selRect.width -= left;
                    }
                    if ((right = selRect.x + selRect.width + insets.right - size.width) > 0) {
                        selRect.width -= right;
                    }
                }
            }
        }
    }

    protected Dimension calculateSize(boolean minimum) {
        int tabPlacement = this.ui.tabPane.getTabPlacement();
        Insets insets = this.ui.tabPane.getInsets();
        Insets contentInsets = this.ui.getContentBorderInsets(tabPlacement);
        Insets tabAreaInsets = this.ui.getTabAreaInsets(tabPlacement);
        int height = 0;
        int width = 0;
        int cWidth = 0;
        int cHeight = 0;
        for (int i = 0; i < this.ui.tabPane.getTabCount(); ++i) {
            Dimension size;
            Component component = this.ui.tabPane.getComponentAt(i);
            if (component == null) continue;
            Dimension dimension = size = minimum ? component.getMinimumSize() : component.getPreferredSize();
            if (size == null) continue;
            cHeight = Math.max(size.height, cHeight);
            cWidth = Math.max(size.width, cWidth);
        }
        width += cWidth;
        height += cHeight;
        switch (tabPlacement) {
            case 2: 
            case 4: {
                height = Math.max(height, this.ui.calculateMaxTabHeight(tabPlacement));
                int tabExtent = this.preferredTabAreaWidth(tabPlacement, height - tabAreaInsets.top - tabAreaInsets.bottom);
                width += tabExtent;
                break;
            }
            default: {
                width = Math.max(width, this.ui.calculateMaxTabWidth(tabPlacement));
                int tabExtent = this.preferredTabAreaHeight(tabPlacement, width - tabAreaInsets.left - tabAreaInsets.right);
                height += tabExtent;
            }
        }
        return new Dimension(width + insets.left + insets.right + contentInsets.left + contentInsets.right, height + insets.bottom + insets.top + contentInsets.top + contentInsets.bottom);
    }

    protected int preferredTabAreaWidth(int tabPlacement, int height) {
        FontMetrics metrics = this.ui.getFontMetrics();
        int tabCount = this.ui.tabPane.getTabCount();
        int total = 0;
        if (tabCount > 0) {
            int columns = 1;
            int y = 0;
            int fontHeight = metrics.getHeight();
            this.ui.maxTabWidth = this.ui.calculateMaxTabWidth(tabPlacement);
            for (int i = 0; i < tabCount; ++i) {
                int tabHeight = this.ui.calculateTabHeight(tabPlacement, i, fontHeight);
                if (y != 0 && y + tabHeight > height) {
                    ++columns;
                    y = 0;
                }
                y += tabHeight;
            }
            total = this.ui.calculateTabAreaWidth(tabPlacement, columns, this.ui.maxTabWidth);
        }
        return total;
    }

    protected int preferredTabAreaHeight(int tabPlacement, int width) {
        FontMetrics metrics = this.ui.getFontMetrics();
        int tabCount = this.ui.tabPane.getTabCount();
        int total = 0;
        if (tabCount > 0) {
            int rows = 1;
            int x = 0;
            int maxTabHeight = this.ui.calculateMaxTabHeight(tabPlacement);
            for (int i = 0; i < tabCount; ++i) {
                int tabWidth = this.ui.calculateTabWidth(tabPlacement, i, metrics);
                if (x != 0 && x + tabWidth > width) {
                    ++rows;
                    x = 0;
                }
                x += tabWidth;
            }
            total = this.ui.calculateTabAreaHeight(tabPlacement, rows, maxTabHeight);
        }
        return total;
    }
}

